package com.ejie.ab04b.webservice.client.dokusi;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

/**
 * This class was generated by the JAX-WS RI. Oracle JAX-WS 2.1.5 Generated
 * source version: 2.1
 * 
 * @author GFI
 */
@WebService(name = "t65bFSDWSClasePort", targetNamespace = "http://www.ejie.es/webServiceClase/t65bFSDWar")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface T65BFSDWSClasePort {

	/**
	 * Removes the locator verification.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDs            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "removeLocatorVerificationResult", partName = "removeLocatorVerificationResult")
	public boolean removeLocatorVerification(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs);

	/**
	 * Restore locator verification.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDs            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "restoreLocatorVerification", partName = "restoreLocatorVerification")
	public boolean restoreLocatorVerification(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs);

	/**
	 * Removes the no prod registered documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @param searchConditionsList            String
	 * @param boolConfirmation            boolean
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "removeNoProdRegisteredDocumentsResult", partName = "removeNoProdRegisteredDocumentsResult")
	public String removeNoProdRegisteredDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolConfirmation", partName = "boolConfirmation") boolean boolConfirmation);

	/**
	 * Verify locator.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param locator            String
	 * @param keysList            String
	 * @param sede            String
	 * @param docLocation            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "verifyLocatorResult", partName = "verifyLocatorResult")
	public String verifyLocator(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "locator", partName = "locator") String locator,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "sede", partName = "sede") String sede,
			@WebParam(name = "docLocation", partName = "docLocation") String docLocation);

	/**
	 * Verify locator pif.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param locator            String
	 * @param keysList            String
	 * @param sede            v
	 * @param pifId            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "verifyLocatorPifResult", partName = "verifyLocatorPifResult")
	public String verifyLocatorPif(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "locator", partName = "locator") String locator,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "sede", partName = "sede") String sede,
			@WebParam(name = "pifId", partName = "pifId") String pifId);

	/**
	 * Relaunch JMS messages.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "relaunchJMSMessagesResult", partName = "relaunchJMSMessagesResult")
	public boolean relaunchJMSMessages(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

	/**
	 * Adds the locator to document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param boolVersion            boolean
	 * @param boolReducir            boolean
	 * @param sede            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "addLocatorToDocumentResult", partName = "addLocatorToDocumentResult")
	public String addLocatorToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") boolean boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * Adds the locator to document sync.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param boolVersion            boolean
	 * @param boolReducir            boolean
	 * @param sede            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "addLocatorToDocumentSyncResult", partName = "addLocatorToDocumentSyncResult")
	public String addLocatorToDocumentSync(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") boolean boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * Adds the locator to document QR.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param boolVersion            boolean
	 * @param boolReducir            boolean
	 * @param sede            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "addLocatorToDocumentQRResult", partName = "addLocatorToDocumentQRResult")
	public String addLocatorToDocumentQR(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") String boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * Adds the locator to document sync QR.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param boolVersion            boolean
	 * @param boolReducir            boolean
	 * @param sede            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "addLocatorToDocumentSyncQRResult", partName = "addLocatorToDocumentSyncQRResult")
	public String addLocatorToDocumentSyncQR(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolVersion", partName = "boolVersion") boolean boolVersion,
			@WebParam(name = "boolReducir", partName = "boolReducir") String boolReducir,
			@WebParam(name = "sede", partName = "sede") String sede);

	/**
	 * Archive document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param attributeList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "archiveDocumentResult", partName = "archiveDocumentResult")
	public boolean archiveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Rearchive document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param newDocumentalType            String
	 * @param attributeList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "rearchiveDocumentResult", partName = "rearchiveDocumentResult")
	public boolean rearchiveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Creates the transformation.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param format            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "createTransformationResult", partName = "createTransformationResult")
	public boolean createTransformation(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Retramitate document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param newDocumentalType            String
	 * @param attributeList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "retramitateDocumentResult", partName = "retramitateDocumentResult")
	public boolean retramitateDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Retramitate documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDs            String
	 * @param attributeList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "retramitateDocumentsResult", partName = "retramitateDocumentsResult")
	public boolean retramitateDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDs", partName = "documentIDs") String documentIDs,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Retramitate documents ex.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentAttrInfoList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "retramitateDocumentsExResult", partName = "retramitateDocumentsExResult")
	public boolean retramitateDocumentsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * Demote documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentAttrInfoList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "demoteDocumentsResult", partName = "demoteDocumentsResult")
	public boolean demoteDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * Tramitate document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param newDocumentalType            String
	 * @param attributeList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "tramitateDocumentResult", partName = "tramitateDocumentResult")
	public boolean tramitateDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "newDocumentalType", partName = "newDocumentalType") String newDocumentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Tramitate documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentAttrInfoList            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "tramitateDocumentsResult", partName = "tramitateDocumentsResult")
	public boolean tramitateDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentAttrInfoList", partName = "documentAttrInfoList") String documentAttrInfoList);

	/**
	 * Delete document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param boolAllVersions            boolean
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "deleteDocumentResult", partName = "deleteDocumentResult")
	public String deleteDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions);

	/**
	 * Modify document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param saveAsVersion            String
	 * @param boolSetCurrent            boolean
	 * @param attributeList            String
	 * @param content            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "modifyDocumentResult", partName = "modifyDocumentResult")
	public String modifyDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "saveAsVersion", partName = "saveAsVersion") String saveAsVersion,
			@WebParam(name = "boolSetCurrent", partName = "boolSetCurrent") boolean boolSetCurrent,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * Modify document clp.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param saveAsVersion            String
	 * @param boolSetCurrent            boolean
	 * @param attributeList            String
	 * @param content            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "modifyDocumentClpResult", partName = "modifyDocumentClpResult")
	public String modifyDocumentClp(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "saveAsVersion", partName = "saveAsVersion") String saveAsVersion,
			@WebParam(name = "boolSetCurrent", partName = "boolSetCurrent") boolean boolSetCurrent,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * Modify registered document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param content            String
	 * @param signatureInfo            String
	 * @param signature            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "modifyRegisteredDocumentResult", partName = "modifyRegisteredDocumentResult")
	public String modifyRegisteredDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * Share document contents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param attributeList            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "shareDocumentContentsResult", partName = "shareDocumentContentsResult")
	public String shareDocumentContents(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Share documents contents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentsToShare            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "shareDocumentsContentsResult", partName = "shareDocumentsContentsResult")
	public String shareDocumentsContents(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentsToShare", partName = "documentsToShare") String documentsToShare);

	/**
	 * Retrieve shared content relationships.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveSharedContentRelationshipsResult", partName = "retrieveSharedContentRelationshipsResult")
	public String retrieveSharedContentRelationships(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Retrieve document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param keysList            String
	 * @param content            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentResult", partName = "retrieveDocumentResult")
	public String retrieveDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * Retrieve document desc.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param keysList            String
	 * @param content            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentDescResult", partName = "retrieveDocumentDescResult")
	public String retrieveDocumentDesc(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "keysList", partName = "keysList") String keysList,
			@WebParam(name = "content", partName = "content") String content);

	/**
	 * Retrieve documents desc.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentsToReturn            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsDescResult", partName = "retrieveDocumentsDescResult")
	public String retrieveDocumentsDesc(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentsToReturn", partName = "documentsToReturn") String documentsToReturn);

	/**
	 * Retrieve document versions ids.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentVersionsIdsResult", partName = "retrieveDocumentVersionsIdsResult")
	public String retrieveDocumentVersionsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Retrieve documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDArray            String
	 * @param keysListArray            String
	 * @param contentArray            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsResult", partName = "retrieveDocumentsResult")
	public String retrieveDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "keysListArray", partName = "keysListArray") String keysListArray,
			@WebParam(name = "contentArray", partName = "contentArray") String contentArray);

	/**
	 * Retrieve documents ids.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @param attributeList            String
	 * @param boolAllVersions            boolean
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsIdsResult", partName = "retrieveDocumentsIdsResult")
	public String retrieveDocumentsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Retrieve documents ids ex.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @param searchConditionsList            String
	 * @param boolAllVersions            boolean
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsIdsExResult", partName = "retrieveDocumentsIdsExResult")
	public String retrieveDocumentsIdsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Adds the signatures to document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param signatures            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "addSignaturesToDocumentResult", partName = "addSignaturesToDocumentResult")
	public boolean addSignaturesToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signatures", partName = "signatures") String signatures);

	/**
	 * Retrieve signatures.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param format            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveSignaturesResult", partName = "retrieveSignaturesResult")
	public String retrieveSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Retrieve signatures count.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param format            String
	 * @return returns int
	 */
	@WebMethod()
	@WebResult(name = "retrieveSignaturesCountResult", partName = "retrieveSignaturesCountResult")
	public int retrieveSignaturesCount(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Gets the application token.
	 *
	 * @param auditUser            String
	 * @param appCode            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "getApplicationTokenResult", partName = "getApplicationTokenResult")
	public String getApplicationToken(
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "appCode", partName = "appCode") String appCode);

	/**
	 * Removes the document location.
	 *
	 * @param auditUser            String
	 * @param documentLocation            String
	 * @param deleteFolder            boolean
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "removeDocumentLocationResult", partName = "removeDocumentLocationResult")
	public String removeDocumentLocation(
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentLocation", partName = "documentLocation") String documentLocation,
			@WebParam(name = "deleteFolder", partName = "deleteFolder") boolean deleteFolder);

	/**
	 * Update signature.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param signature            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "updateSignatureResult", partName = "updateSignatureResult")
	public boolean updateSignature(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * Update signatures.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param signatureInfo            String
	 * @param signature            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "updateSignaturesResult", partName = "updateSignaturesResult")
	public boolean updateSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo,
			@WebParam(name = "signature", partName = "signature") String signature);

	/**
	 * Retrieve signed documents ids.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param signatureInfo            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveSignedDocumentsIdsResult", partName = "retrieveSignedDocumentsIdsResult")
	public String retrieveSignedDocumentsIds(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "signatureInfo", partName = "signatureInfo") String signatureInfo);

	/**
	 * Retrieve documents signatures.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDArray            String
	 * @param format            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsSignaturesResult", partName = "retrieveDocumentsSignaturesResult")
	public String retrieveDocumentsSignatures(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Retrieve documents signatures ex.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDArray            String
	 * @param keysListArray            String
	 * @param format            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsSignaturesExResult", partName = "retrieveDocumentsSignaturesExResult")
	public String retrieveDocumentsSignaturesEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray,
			@WebParam(name = "keysListArray", partName = "keysListArray") String keysListArray,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Search documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @param returnedAttributeKeysList            String
	 * @param searchAttributeList            String
	 * @param boolAllVersions            boolean
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "searchDocumentsResult", partName = "searchDocumentsResult")
	public String searchDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchAttributeList", partName = "searchAttributeList") String searchAttributeList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Search documents full text.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param returnedAttributeKeysList            String
	 * @param searchConditionsList            String
	 * @param searchParamsList            String
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "searchDocumentsFullTextResult", partName = "searchDocumentsFullTextResult")
	public String searchDocumentsFullText(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "searchParamsList", partName = "searchParamsList") String searchParamsList,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Search parametrics full text.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param parametricAttributeKeysList            String
	 * @param searchConditionsList            String
	 * @param searchParamsList            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "searchParametricsFullTextResult", partName = "searchParametricsFullTextResult")
	public String searchParametricsFullText(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "parametricAttributeKeysList", partName = "parametricAttributeKeysList") String parametricAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "searchParamsList", partName = "searchParamsList") String searchParamsList);

	/**
	 * Gets the document index info.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "getDocumentIndexInfoResult", partName = "getDocumentIndexInfoResult")
	public String getDocumentIndexInfo(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Search documents ex.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @param returnedAttributeKeysList            String
	 * @param searchConditionsList            String
	 * @param boolAllVersions            boolean
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "searchDocumentsExResult", partName = "searchDocumentsExResult")
	public String searchDocumentsEx(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Search documents untyped.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param returnedAttributeKeysList            String
	 * @param searchConditionsList            String
	 * @param boolAllVersions            boolean
	 * @param intMaxRows            int
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "searchDocumentsUntypedResult", partName = "searchDocumentsUntypedResult")
	public String searchDocumentsUntyped(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "returnedAttributeKeysList", partName = "returnedAttributeKeysList") String returnedAttributeKeysList,
			@WebParam(name = "searchConditionsList", partName = "searchConditionsList") String searchConditionsList,
			@WebParam(name = "boolAllVersions", partName = "boolAllVersions") boolean boolAllVersions,
			@WebParam(name = "intMaxRows", partName = "intMaxRows") int intMaxRows);

	/**
	 * Verify document format.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "verifyDocumentFormatResult", partName = "verifyDocumentFormatResult")
	public String verifyDocumentFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Modify document format.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param formatName            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "modifyDocumentFormatResult", partName = "modifyDocumentFormatResult")
	public boolean modifyDocumentFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "formatName", partName = "formatName") String formatName);

	/**
	 * Store document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param content            String
	 * @param documentalType            String
	 * @param attributeList            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "storeDocumentResult", partName = "storeDocumentResult")
	public String storeDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Store document verification format.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param content            String
	 * @param documentalType            String
	 * @param attributeList            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "storeDocumentVerificationFormatResult", partName = "storeDocumentVerificationFormatResult")
	public String storeDocumentVerificationFormat(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType,
			@WebParam(name = "attributeList", partName = "attributeList") String attributeList);

	/**
	 * Store documents.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param contentArray            String
	 * @param documentalTypeArray            String
	 * @param attributeListArray            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "storeDocumentsResult", partName = "storeDocumentsResult")
	public String storeDocuments(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "contentArray", partName = "contentArray") String contentArray,
			@WebParam(name = "documentalTypeArray", partName = "documentalTypeArray") String documentalTypeArray,
			@WebParam(name = "attributeListArray", partName = "attributeListArray") String attributeListArray);

	/**
	 * Retrieve available formats.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param format            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveAvailableFormatsResult", partName = "retrieveAvailableFormatsResult")
	public String retrieveAvailableFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "format", partName = "format") String format);

	/**
	 * Retrieve document formats.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentFormatsResult", partName = "retrieveDocumentFormatsResult")
	public String retrieveDocumentFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Retrieve documents formats.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentIDArray            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentsFormatsResult", partName = "retrieveDocumentsFormatsResult")
	public String retrieveDocumentsFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentIDArray", partName = "documentIDArray") String documentIDArray);

	/**
	 * Retrieve document valid formats.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveDocumentValidFormatsResult", partName = "retrieveDocumentValidFormatsResult")
	public String retrieveDocumentValidFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID);

	/**
	 * Adds the digitalization to document.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentID            String
	 * @param content            String
	 * @param digitType            String
	 * @param digitDate            String
	 * @return returns boolean
	 */
	@WebMethod()
	@WebResult(name = "addDigitalizationToDocumentResult", partName = "addDigitalizationToDocumentResult")
	public boolean addDigitalizationToDocument(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentID", partName = "documentID") String documentID,
			@WebParam(name = "content", partName = "content") String content,
			@WebParam(name = "digitType", partName = "digitType") String digitType,
			@WebParam(name = "digitDate", partName = "digitDate") String digitDate);

	/**
	 * Retrieve type definition.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param documentalType            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveTypeDefinitionResult", partName = "retrieveTypeDefinitionResult")
	public String retrieveTypeDefinition(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "documentalType", partName = "documentalType") String documentalType);

	/**
	 * Retrieve attributed type names.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param attributeKeysList            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveAttributedTypeNamesResult", partName = "retrieveAttributedTypeNamesResult")
	public String retrieveAttributedTypeNames(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "attributeKeysList", partName = "attributeKeysList") String attributeKeysList);

	/**
	 * Retrieve available transformation formats.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param ctsFormat            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveAvailableTransformationFormatsResult", partName = "retrieveAvailableTransformationFormatsResult")
	public String retrieveAvailableTransformationFormats(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "ctsFormat", partName = "ctsFormat") String ctsFormat);

	/**
	 * Retrieve available formats scenarios.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveAvailableFormatsScenariosResult", partName = "retrieveAvailableFormatsScenariosResult")
	public String retrieveAvailableFormatsScenarios(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

	/**
	 * Retrieve formats scenario.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @param formatsScenarioId            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveFormatsScenarioResult", partName = "retrieveFormatsScenarioResult")
	public String retrieveFormatsScenario(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser,
			@WebParam(name = "formatsScenarioId", partName = "formatsScenarioId") String formatsScenarioId);

	/**
	 * Retrieve locator timer dates.
	 *
	 * @param integrationToken            String
	 * @param auditUser            String
	 * @return returns java.lang.String
	 */
	@WebMethod()
	@WebResult(name = "retrieveLocatorTimerDatesResult", partName = "retrieveLocatorTimerDatesResult")
	public String retrieveLocatorTimerDates(
			@WebParam(name = "integrationToken", partName = "integrationToken") String integrationToken,
			@WebParam(name = "auditUser", partName = "auditUser") String auditUser);

}
